// API Test Script - cPanel için
const http = require('http');

// Test edilecek endpoint'ler
const endpoints = [
    { path: '/api/categories', method: 'GET', name: 'Kategorileri Getir' },
    { path: '/api/candidates', method: 'GET', name: 'Adayları Getir' },
    { path: '/api/customers', method: 'GET', name: 'Müşterileri Getir' },
    { path: '/api/selections', method: 'GET', name: 'Seçimleri Getir' },
    { path: '/api/cities', method: 'GET', name: 'Şehirleri Getir' }
];

// Server adresini buraya girin
const SERVER_URL = 'http://api.melinajans.com';

console.log('🚀 API Testi Başlatılıyor...');
console.log(`📍 Server: ${SERVER_URL}\n`);

endpoints.forEach((endpoint, index) => {
    const options = {
        hostname: 'api.melinajans.com',
        port: 80,
        path: endpoint.path,
        method: endpoint.method,
        headers: {
            'Content-Type': 'application/json',
            'Host': 'api.melinajans.com'
        }
    };

    const req = http.request(options, (res) => {
        let data = '';
        
        res.on('data', (chunk) => {
            data += chunk;
        });
        
        res.on('end', () => {
            try {
                const response = JSON.parse(data);
                console.log(`✅ ${index + 1}. ${endpoint.name}`);
                console.log(`   Status: ${res.statusCode}`);
                console.log(`   Path: ${endpoint.method} ${endpoint.path}`);
                console.log(`   Response: ${response.message || 'Başarılı'}\n`);
            } catch (e) {
                console.log(`❌ ${index + 1}. ${endpoint.name}`);
                console.log(`   Status: ${res.statusCode}`);
                console.log(`   Path: ${endpoint.method} ${endpoint.path}`);
                console.log(`   Error: ${data}\n`);
            }
        });
    });

    req.on('error', (error) => {
        console.log(`❌ ${index + 1}. ${endpoint.name}`);
        console.log(`   Path: ${endpoint.method} ${endpoint.path}`);
        console.log(`   Error: ${error.message}\n`);
    });

    req.end();
});

// 5 saniye bekle ve sonuçları özetle
setTimeout(() => {
    console.log('📊 Test Özeti:');
    console.log('• Tüm endpoint\'ler çalışıyorsa backend hazır demektir');
    console.log('• Hata alan endpoint\'ler için veritabanı bağlantısını kontrol edin');
    console.log('• Server loglarını kontrol edin: node server.js');
}, 6000);
